//-------------------------------------------------------------------------------
// FILE: SAMPLE13.CPP
//
// OCT sample for How Do I in OS/2 e-Zine!
//
// Created by Eric Slaats
// File created with Smalled 1.49.02
//-------------------------------------------------------------------------------
#define  INCL_WIN
#include <os2.h>

#include <stdio.h>

#include "sample13.h"

//-------------------------------------------------------------------------------
//Dialog Window procedure prototype
//-------------------------------------------------------------------------------
MRESULT EXPENTRY DlgMenu (HWND, ULONG ,MPARAM, MPARAM);

//-------------------------------------------------------------------------------
// Main
//
// Sets up a simple dialogbox to demonstrate that a dialog can act as a main
// window
// By using a dialog none of the usual window control has to be included.
// Everything exept the coupling of the menu is done in a dialog editor.
//-------------------------------------------------------------------------------

void main(void)
	{
	HAB hab = WinInitialize(0);
	HMQ hmq = WinCreateMsgQueue(hab,0);

	WinDlgBox(HWND_DESKTOP,
			HWND_DESKTOP,
			DlgMenu,
			NULLHANDLE,
			DIALOGWIN,
			0);

	WinDestroyMsgQueue(hmq);
	WinTerminate(hab);
	}


//---------------------------------------------------------------------------------
// dialog procedure
//---------------------------------------------------------------------------------
MRESULT EXPENTRY DlgMenu(HWND hwndDlg, ULONG msg, MPARAM mp1, MPARAM mp2)
	{
	switch (msg)
		{
		//-----------------------------------------------------------------------
		// Handle the initialization of the dialog
		//-----------------------------------------------------------------------
		case WM_INITDLG:
			{
			//------------------------------------------------------------------
			// Set icon
			//------------------------------------------------------------------
			HPOINTER hptr = (HPOINTER)WinLoadPointer(HWND_DESKTOP, NULLHANDLE, 1);
			WinSendMsg(hwndDlg, WM_SETICON, (MPARAM) hptr, 0l);
			//------------------------------------------------------------------
			// Attach menu
			//------------------------------------------------------------------
			WinLoadMenu(hwndDlg, NULLHANDLE, MAIN);
			WinSendMsg(hwndDlg, WM_UPDATEFRAME, (MPARAM) FCF_MENU, 0l);
			}
		break;

		//-----------------------------------------------------------------------
		// Handle the WM_CONTROL message
		//-----------------------------------------------------------------------
		case WM_CONTROL:
			{
			char achControl[32];
			char achNotify[32];

			//------------------------------------------------------------------
			// Determine which entryfield send the control message  (short 1)
			//------------------------------------------------------------------
			switch (SHORT1FROMMP(mp1))
				{
				case ENTRYFIELD1: sprintf(achControl,"Entry1 "); break;
				case ENTRYFIELD2: sprintf(achControl,"Entry2 "); break;
				}

			//------------------------------------------------------------------
			// Determine which notification was given  (short 2)
			//------------------------------------------------------------------
			switch (SHORT2FROMMP(mp1))
				{
				case EN_CHANGE:    sprintf(achNotify, "EN_CHANGE \n");	   break;
				case EN_KILLFOCUS: sprintf(achNotify, "EN_KILLFOCUS \n"); break;
				case EN_MEMERROR:  sprintf(achNotify, "EN_MEMERROR \n");  break;
				case EN_OVERFLOW:  sprintf(achNotify, "EN_OVERFLOW \n");  break;
				case EN_SCROLL:    sprintf(achNotify, "EN_SCROLL \n");    break;
				case EN_SETFOCUS:  sprintf(achNotify, "EN_SETFOCUS \n");  break;
				//-------------------------------------------------------------
				// For undocumented stuff like EN_INSERTMODETOGGLE, EN_UPDATE etc.
				//-------------------------------------------------------------
				default: sprintf(achNotify, "%x \n", SHORT2FROMMP(mp1));  break;
				}

			//------------------------------------------------------------------
			// Make sure it doesn't print on MLE notifications
			//------------------------------------------------------------------
			if (SHORT1FROMMP(mp1) != MLE1)
				{
				WinSendDlgItemMsg(hwndDlg, MLE1, MLM_INSERT, achControl, 0l);
				WinSendDlgItemMsg(hwndDlg, MLE1, MLM_INSERT, achNotify, 0l);
				}
			}
		break;


		//-----------------------------------------------------------------------
		// Handle WM_COMMAND
		// Only one menuitem, and that is exit!
		//-----------------------------------------------------------------------
		case WM_COMMAND:
			WinSendMsg(hwndDlg, WM_CLOSE, 0L, 0L);
		break;
		}
	return WinDefDlgProc(hwndDlg, msg, mp1, mp2);
	}