//---------------------------------------------------------------------------------------------
// File SAMPLE11.CPP (Eric Slaats 1997)
//
// Created for OS/2 e-Zine! (Sept 97)
// File created with Smalled 1.46.04
//---------------------------------------------------------------------------------------------
#define INCL_WIN
#define INCL_DOS

#include <os2.h>
#include <stdio.h>
#include "sample11.h"
//------------------------------------------------------------------------------
// Prototypes
//------------------------------------------------------------------------------
MRESULT EXPENTRY ClientWndProc (HWND,ULONG,MPARAM,MPARAM);

HWND hwndFrame;

void main()
     {
     HAB   hab;                    // Anchor
     HMQ   hmq;                    // Message queue handle
     QMSG  qmsg;                   // Message struct
     HWND  hwndClient;             // Client window handles

     ULONG flFrameFlags = FCF_TITLEBAR   |FCF_SYSMENU |FCF_SHELLPOSITION |
					 FCF_SIZEBORDER |FCF_MINMAX  |FCF_TASKLIST| FCF_MENU;

	//-------------------------------------------------------------------------
	// Initialize application and create message queue
	//-------------------------------------------------------------------------
	hab = WinInitialize (0);
	hmq = WinCreateMsgQueue (hab, 0);
	//-------------------------------------------------------------------------
	// Register class and create window
	//-------------------------------------------------------------------------
	WinRegisterClass (hab, "SampleClass", ClientWndProc, CS_SIZEREDRAW, 0);

	hwndFrame = WinCreateStdWindow (HWND_DESKTOP,     // Parent
							  WS_VISIBLE,       // Style (visible)
							  &flFrameFlags,    // Creation flags
							  "SampleClass",    // Class name
							  "Sample 11 for OS/2 e-Zine!",// Titlebar text
							  0,                // Client style
							  NULLHANDLE,       // Resource handle
							  MAIN,             // Frame ID
							  &hwndClient);     // Client handle
	//-------------------------------------------------------------------------
	// Message loop
	//-------------------------------------------------------------------------
	while (WinGetMsg (hab, &qmsg, 0, 0, 0))
		 WinDispatchMsg (hab, &qmsg);
	//-------------------------------------------------------------------------
	// Clean up (destroy window, queue and hab)
	//-------------------------------------------------------------------------
	WinDestroyWindow (hwndFrame);
	WinDestroyMsgQueue (hmq);
	WinTerminate (hab);
	}


//------------------------------------------------------------------------------
// Window procedure
//------------------------------------------------------------------------------
MRESULT EXPENTRY ClientWndProc (HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
	{
	switch (msg)
		{
		//--------------------------------------------------------------------
		// Fill client with default color
		//--------------------------------------------------------------------
		case WM_ERASEBACKGROUND:
		return MRFROMSHORT(TRUE);

		//--------------------------------------------------------------------
		// Handling of the menu-items by WM_COMMAND
		//--------------------------------------------------------------------
		case WM_COMMAND:
			{
               switch(SHORT1FROMMP(mp1))
				{
				case IDM_SEND:
					WinSendMsg(hwnd, UM_BEEP, 0L, 0L);
					WinSetWindowText(hwndFrame, "This");
					DosSleep(500);
					WinSetWindowText(hwndFrame, "This is");
					DosSleep(500);
					WinSetWindowText(hwndFrame, "This is a");
					DosSleep(500);
					WinSetWindowText(hwndFrame, "This is a test");				break;

				case IDM_POST:
					WinPostMsg(hwnd, UM_BEEP, 0L, 0L);
					WinSetWindowText(hwndFrame, "This");
					DosSleep(500);
					WinSetWindowText(hwndFrame, "This is");
					DosSleep(500);
					WinSetWindowText(hwndFrame, "This is a");
					DosSleep(500);
					WinSetWindowText(hwndFrame, "This is a test");				break;
				}			}
		break;

		//--------------------------------------------------------------------
		// Handle the user message (only a long range of beeps)
		//--------------------------------------------------------------------
		case UM_BEEP:
			{
			short I;
			for(I=1; I<100; I++)
				DosBeep(10*I, 10);
			}
		break;
		}
	return (WinDefWindowProc (hwnd,msg,mp1,mp2));
	}

