//---------------------------------------------------------------------------------------------
// File SAMPLE9.CPP (Example for OS/2 e-Zine!) Eric Slaats 1997
//
// Juli 1997
// Created with Smalled
//
// Introduction to dialogs
//---------------------------------------------------------------------------------------------
#define INCL_WIN
#define INCL_DOS

#include <os2.h>
#include <stdio.h>
#include "sample9.h"
//------------------------------------------------------------------------------
// Prototypes
//------------------------------------------------------------------------------
MRESULT EXPENTRY ClientWndProc (HWND,ULONG,MPARAM,MPARAM);

HWND  hwndFrame;			// FrameHandle
HAB   hab;                    // Anchor


void main()
	{
	HMQ   hmq;                    // Message queue handle
	QMSG  qmsg;                   // Message struct
	HWND  hwndClient;             // Client window handles

	ULONG flFrameFlags = FCF_TITLEBAR   |FCF_SYSMENU |FCF_SHELLPOSITION |
					 FCF_SIZEBORDER |FCF_MINMAX  |FCF_TASKLIST |FCF_MENU;

	//-------------------------------------------------------------------------
	// Initialize application and create message queue
	//-------------------------------------------------------------------------
	hab = WinInitialize (0);
	hmq = WinCreateMsgQueue (hab, 0);
	//-------------------------------------------------------------------------
	// Register class and create window
	//-------------------------------------------------------------------------
	WinRegisterClass (hab, "SampleClass", ClientWndProc, CS_SIZEREDRAW, 0);

	hwndFrame = WinCreateStdWindow (HWND_DESKTOP,     // Parent
							  WS_VISIBLE,       // Style (visible)
							  &flFrameFlags,    // Creation flags
							  "SampleClass",    // Class name
							  "Sample9 for OS/2 e-Zine!",// Titlebar text
							  0,                // Client style
							  NULLHANDLE,       // Resource handle
							  MAIN,             // Frame ID
							  &hwndClient);     // Client handle
	//-------------------------------------------------------------------------
	// Message loop
	//-------------------------------------------------------------------------
	while (WinGetMsg (hab, &qmsg, 0, 0, 0))
		 WinDispatchMsg (hab, &qmsg);
	//-------------------------------------------------------------------------
	// Clean up (destroy window, queue and hab)
	//-------------------------------------------------------------------------
	WinDestroyWindow (hwndFrame);
	WinDestroyMsgQueue (hmq);
	WinTerminate (hab);
	}


//------------------------------------------------------------------------------
// Window procedure
//------------------------------------------------------------------------------
MRESULT EXPENTRY ClientWndProc (HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
	{
	switch (msg)
		{
		//--------------------------------------------------------------------
		// Fill client with default color
		//--------------------------------------------------------------------
		case WM_PAINT:
			{
			RECTL rectl ;
			HPS   hps;

			hps = WinBeginPaint( hwnd, (HPS) NULL, &rectl);
			WinFillRect( hps, (PRECTL)&rectl, CLR_DARKGRAY);
			WinEndPaint( hps );
			}
		return MRFROMSHORT(TRUE);
		//--------------------------------------------------------------------
		// Handling of the menu-items and the button by WM_COMMAND
		//--------------------------------------------------------------------
		case WM_COMMAND:
			{
			switch(SHORT1FROMMP(mp1))
				{
				case IDM_DIALOG1:
					WinDlgBox (HWND_DESKTOP,		// Parent
							 hwnd,        		// Owner
							 WinDefDlgProc,	// Dialog window procedure
							 NULLHANDLE,		// Where is the dialog resource?
							 DIALOG1,			// Dialog Resource ID
							 0);				// Creation parameters (used in WM_INITDLG)
				break;

				case IDM_DIALOG2:
					{
					static HWND hwndDlg = 0;

					WinSetActiveWindow(HWND_DESKTOP,hwndDlg);
					if (!WinIsWindowShowing(hwndDlg))
						{
						hwndDlg = WinLoadDlg(HWND_DESKTOP,		// Parent
										 hwnd,        		// Owner
										 WinDefDlgProc,	// Dialog window procedure
										 NULLHANDLE,		// Where is the dialog resource?
										 DIALOG1,			// Dialog Resource ID
										 0);				// Creation parameters (used in WM_INITDLG)
						}
					}
				break;
				}
			//---------------------------------------------------------------
			// Display message box
			//---------------------------------------------------------------
			}
		break;
		}
	return (WinDefWindowProc (hwnd,msg,mp1,mp2));
	}

