//---------------------------------------------------------------------------------------------
// File SAMPLE8.CPP (Example for OS/2 e-Zine!) Eric Slaats 1997
//
// May 1997
// Created with Smalled
//
// Introduction to dialogs
//---------------------------------------------------------------------------------------------
#define INCL_WIN
#define INCL_DOS

#include <os2.h>
#include <stdio.h>
#include "sample8.h"
//------------------------------------------------------------------------------
// Prototypes
//------------------------------------------------------------------------------
MRESULT EXPENTRY ClientWndProc (HWND,ULONG,MPARAM,MPARAM);

HWND hwndFrame;

void main()
     {
     HAB   hab;                    // Anchor
     HMQ   hmq;                    // Message queue handle
     QMSG  qmsg;                   // Message struct
     HWND  hwndClient;             // Client window handles

	ULONG flFrameFlags = FCF_TITLEBAR   |FCF_SYSMENU |FCF_SHELLPOSITION |
                          FCF_SIZEBORDER |FCF_MINMAX  |FCF_TASKLIST|
                          FCF_MENU;

     //-------------------------------------------------------------------------
     // Initialize application and create message queue
     //-------------------------------------------------------------------------
     hab = WinInitialize (0);
     hmq = WinCreateMsgQueue (hab, 0);
     //-------------------------------------------------------------------------
     // Register class and create window
     //-------------------------------------------------------------------------
     WinRegisterClass (hab, "SampleClass", ClientWndProc, CS_SIZEREDRAW, 0);

     hwndFrame = WinCreateStdWindow (HWND_DESKTOP,     // Parent
                                     WS_VISIBLE,       // Style (visible)
                                     &flFrameFlags,    // Creation flags
                                     "SampleClass",    // Class name
                                     "Sample8 for OS/2 e-Zine!",// Titlebar text
							  0,                // Client style
                                     NULLHANDLE,       // Resource handle
                                     MAIN,             // Frame ID
                                     &hwndClient);     // Client handle
     //-------------------------------------------------------------------------
     // Message loop
     //-------------------------------------------------------------------------
     while (WinGetMsg (hab, &qmsg, 0, 0, 0))
           WinDispatchMsg (hab, &qmsg);
     //-------------------------------------------------------------------------
     // Clean up (destroy window, queue and hab)
     //-------------------------------------------------------------------------
	WinDestroyWindow (hwndFrame);
	WinDestroyMsgQueue (hmq);
	WinTerminate (hab);
	}


//------------------------------------------------------------------------------
// Window procedure
//------------------------------------------------------------------------------
MRESULT EXPENTRY ClientWndProc (HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
	{
	switch (msg)
		{
		//--------------------------------------------------------------------
		// Fill client with default color
		//--------------------------------------------------------------------
		case WM_PAINT:
			{
               RECTL rectl ;
               HPS   hps;

               hps = WinBeginPaint( hwnd, (HPS) NULL, &rectl);
			WinFillRect( hps, (PRECTL)&rectl, CLR_DARKGRAY);
               WinEndPaint( hps );
               }
		return MRFROMSHORT(TRUE);
		//--------------------------------------------------------------------
		// Handling of the menu-items and the button by WM_COMMAND
		//--------------------------------------------------------------------
		case WM_COMMAND:
			{
			switch(SHORT1FROMMP(mp1))
				{
				case IDM_BOX_11:
					WinMessageBox(hwnd, hwnd, "Owner and Parent clientwindow", "Modal box", 1, MB_OK|MB_MOVEABLE|MB_SYSTEMMODAL);
				break;

				case IDM_BOX_12:
					WinMessageBox(HWND_DESKTOP, hwnd, "Owner=clientwindow Parent=Desktop", "Modal box", 1, MB_OK|MB_MOVEABLE|MB_SYSTEMMODAL);
				break;

				case IDM_BOX_21:
					WinMessageBox(hwnd, hwnd, "Owner and Parent clientwindow", "Modeless box", 1, MB_OK|MB_MOVEABLE);
				break;

				case IDM_BOX_22:
					WinMessageBox(hwnd, HWND_DESKTOP, "Owner=clientwindow Parent=Desktop", "Modeless box", 1, MB_OK|MB_MOVEABLE);
				break;

				case IDM_BOX_23:
					WinMessageBox(HWND_DESKTOP, HWND_DESKTOP, "Owner=DESKTOP Parent=Desktop", "Modeless box", 1, MB_OK|MB_MOVEABLE);
				break;
				case IDM_ABOUT:
					WinMessageBox(hwnd,hwnd, "Sample8 for OS/2 e-Zine!", "About", 0, MB_OK|MB_MOVEABLE|MB_SYSTEMMODAL);
				break;
				}
			//---------------------------------------------------------------
			// Display message box
			//---------------------------------------------------------------
			}
		break;
		}
	return (WinDefWindowProc (hwnd,msg,mp1,mp2));
	}

