//---------------------------------------------------------------------------------------------
// File SAMPLE7.CPP (Eric Slaats April 97 for OS/2 e-Zine!)
//
// April 1997
// Saving the window status second variant
//---------------------------------------------------------------------------------------------
#define INCL_WIN
#define INCL_DOS

#include <os2.h>
#include <stdio.h>
#include "sample7.h"

//------------------------------------------------------------------------------
// Global variables
//------------------------------------------------------------------------------
HAB   hab;       // Anchor
//------------------------------------------------------------------------------
// Prototypes
//------------------------------------------------------------------------------
MRESULT EXPENTRY ClientWndProc (HWND,ULONG,MPARAM,MPARAM);

HWND hwndFrame;

void main()
	{
	HMQ   hmq;                    // Message queue handle
	QMSG  qmsg;                   // Message struct
	HWND  hwndClient;             // Client window handles

	//-------------------------------------------------------------------------
	// Initialize application and create message queue
	//-------------------------------------------------------------------------
	hab = WinInitialize (0);
	hmq = WinCreateMsgQueue (hab, 0);

	//Get info from the private ini file to a buffer
	HINI    hini;   // Handle to private INI file
	ULONG   ulSize; // Size of the data to be copied
	PVOID   pBuffer;// Buffer

	hini = PrfOpenProfile(hab, "Sample7.INI"); // Open private profile
	if (hini)
		{
		//----------------------------------------------------------------------
		// Query the info from a private INI into a memory buffer
		//----------------------------------------------------------------------
		PrfQueryProfileSize(hini, APPNAME, WINPOS, &ulSize);
		DosAllocMem(&pBuffer, ulSize, PAG_READ| PAG_WRITE |PAG_COMMIT);
		PrfQueryProfileData(hini, APPNAME, WINPOS, pBuffer, &ulSize);
		PrfCloseProfile(hini); 	// Close private profile
		//----------------------------------------------------------------------
		// Write the info to the OS2.INI
		//----------------------------------------------------------------------
		PrfWriteProfileData(HINI_USERPROFILE, APPNAME, WINPOS, pBuffer, ulSize);
		DosFreeMem(pBuffer);
		}


	ULONG flFrameFlags = FCF_TITLEBAR   |FCF_SYSMENU |FCF_MENU    |
					 FCF_SIZEBORDER |FCF_MINMAX  |FCF_TASKLIST;

	ULONG ulIniSize = 0;
	if(!PrfQueryProfileSize(HINI_USERPROFILE, APPNAME, WINPOS, &ulIniSize) || !ulIniSize)
		flFrameFlags |= FCF_SHELLPOSITION;
	//-------------------------------------------------------------------------
	// Register class and create window
	//-------------------------------------------------------------------------
	WinRegisterClass (hab, "SampleClass", ClientWndProc, CS_SIZEREDRAW, 0);

	hwndFrame = WinCreateStdWindow (HWND_DESKTOP,     // Parent
							  WS_VISIBLE,       // Style (visible)
							  &flFrameFlags,    // Creation flags
							  "SampleClass",    // Class name
							  "Sample 7 for OS/2 e-Zine!",// Titlebar text
							  0,                // Client style
							  NULLHANDLE,       // Resource handle
							  MAIN,             // Frame ID
							  &hwndClient);     // Client handle

	//-------------------------------------------------------------------------
	// Restore size/place and PP fromOS2.INI
	//-------------------------------------------------------------------------
	if (ulIniSize)
		WinRestoreWindowPos(APPNAME, WINPOS, hwndFrame);
	//-------------------------------------------------------------------------
	// Message loop
	//-------------------------------------------------------------------------
	while (WinGetMsg (hab, &qmsg, 0, 0, 0))
		WinDispatchMsg (hab, &qmsg);
	//-------------------------------------------------------------------------
	// Clean up (destroy window, queue and hab)
	//-------------------------------------------------------------------------
	WinDestroyWindow (hwndFrame);
	WinDestroyMsgQueue (hmq);
	WinTerminate (hab);
	}


//------------------------------------------------------------------------------
// Window procedure
//------------------------------------------------------------------------------
MRESULT EXPENTRY ClientWndProc (HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
	{
	switch (msg)
		{
		//--------------------------------------------------------------------
		// Fill client with default color
		//--------------------------------------------------------------------
		case WM_ERASEBACKGROUND:
		return MRFROMSHORT(TRUE);
		//--------------------------------------------------------------------
		// Handle the menu and accelerator commands
		//--------------------------------------------------------------------
		case WM_COMMAND:
			{
			WinPostMsg(hwnd, WM_CLOSE, 0, 0);
			}
		break;

		//----------------------------------------------------------------------------
		// Save the window size and position on exit
		//----------------------------------------------------------------------------
		case WM_SAVEAPPLICATION:
			{
			//-------------------------------------------------------------------
			// Check if window is minimized and restore to original size
			//-------------------------------------------------------------------
			if (WinQueryWindowULong(hwndFrame, QWL_STYLE) & WS_MINIMIZED)
				WinSetWindowPos(hwndFrame, HWND_TOP, 0,0,0,0, SWP_RESTORE);

			HINI 	hini;   // Handle to private INI file
			ULONG   ulSize; // Size of the data to be copied
			PVOID	pBuffer;// Buffer
			//------------------------------------------------------------------
			// Store window information in OS2.INI
			//------------------------------------------------------------------
			WinStoreWindowPos(APPNAME, WINPOS, WinQueryWindow(hwnd, QW_PARENT));
			//------------------------------------------------------------------
			// Copy the info from the OS2.INI into a memory buffer
			// and delete it from the OS2.INI file
			//------------------------------------------------------------------
			PrfQueryProfileSize(HINI_USERPROFILE, APPNAME, WINPOS, &ulSize);
			DosAllocMem(&pBuffer, ulSize, PAG_READ| PAG_WRITE |PAG_COMMIT);
			PrfQueryProfileData(HINI_USERPROFILE, APPNAME, WINPOS, pBuffer, &ulSize);
			PrfWriteProfileData(HINI_USERPROFILE, APPNAME, WINPOS, NULL, 0);
			//------------------------------------------------------------------
			// Copy the info from the buffer to the private ini file
			// Close the private ini file and free the used memory
			//------------------------------------------------------------------
			hini = PrfOpenProfile(hab, "Sample7.INI"); // Open private profile
			PrfWriteProfileData(hini, APPNAME, WINPOS, pBuffer, ulSize);
			PrfCloseProfile(hini); 	// Close private profile
			DosFreeMem(pBuffer);
			}
		break;
		}
	return (WinDefWindowProc (hwnd,msg,mp1,mp2));
	}

