/* POSIZ.CMD                                             */
/* uso: posiz(stringa, testo)                            */

/* controlla gli argomenti immessi                       */
if arg() \= 2 then         /* se non ci sono 2 argomenti */
   return                  /* restituisce ""             */
if arg(1, "O") then        /* se il secondo argomento   */
   return                  /* nullo restituisce ""       */

/* assegna gli argomenti alle variabili stringa e testo  */
parse arg stringa, testo   

/* calcola la massima posizione possibile per la stringa */
maxpos = length(testo) - length(stringa) + 1
 
/* cerca "stringa" in "testo"                            */
do risultato = 1 to maxpos,
   until substr(testo, risultato, length(stringa)) = stringa
   end

/* restituisce la posizione di "stringa" o "0" nel caso  */
/* questa non sia presente in testo                      */
if risultato > maxpos then
   risultato = 0
return risultato
