/* BACKITUP.CMD: fa una copia di backup di un programma REXX             */
arg fname"."ext          /* attraverso questo costrutto viene effettuato */
                         /* il "parsing" dell'argomento scomponendolo    */
                         /* nelle due parti: "nome file" e "estensione"  */

if fname = "" then do    /* se non si  introdotto il nome del file      */
   say "Scrivi il nome del file"         /* lo chiede all'utente         */
   pull fname"."ext
   end

if ext = "" then ext = "CMD"             /* se non c' l'estensione usa  */
                                         /* ".CMD" come estensione       */

"@dir" fname"."ext       /* esegue il comando "DIR" sul nome del file    */
                         /* introdotto per controllare che sia valido    */
  
if rc \= 0 then do                       /* se il file non esiste mostra */
   say "Impossibile eseguire il backup!" /* un messaggio di errore e     */
   say "Programma terminato."            /* termina                      */
   exit
   end
else do                                  /* altrimenti copia il file in  */
   say "Backing up" fname"."ext          /* un nuovo file con estensione */
   "@copy" fname"."ext  fname".BKP"      /* ".BKP"; mostrandone i dati   */
   "@dir" fname".BKP"                    /* tramite il comando "DIR"     */
   say "Programma terminato."
   exit
   end

