/* swapmon.cmd  V. 0.31 * (c) 1996 Alessandro Cantatore * Team OS/2 Italy */
arg interval option

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs';
call SysLoadFuncs;

if interval = "-?" | interval = "?" | interval = "/H" | interval = "-H" then
   call showusage;

if left(interval, 1) = "/" | left(interval, 1) = "-" then
   option = interval;

if \datatype(interval, "N") then
   interval = 1

/* gets boot disk as suggested by Dick Goran in OS/2 Magazine */
parse upper value value("path", , "OS2ENVIRONMENT") with "\OS2\SYSTEM" -2,
                  bdrv +2

/* gets swap file path (scans config.sys for SWAPPATH statements */
if 0 \= SysFileSearch("SWAPPATH", bdrv"\CONFIG.SYS", "statement") then do
   call beep 880, 200
   say " SysFileSearch() error #"rc
   say
   "@pause"
   exit
end /* do */

/* discards invalid statements (comments) */
do i = 1 to statement.0
   if "SWAPPATH" = left(statement.i, 8) then do
      parse var statement.i "=" swappath . . 
      leave
   end /* do */
end /* do */

if right(swappath, 1) = "\" then
   swappath = swappath || "SWAPPER.DAT"
else
   swappath = swappath || "\SWAPPER.DAT"

logfile = swapmon.log;
maxsize = 0;
bar = ""
call SysCurState "OFF"
say "1b"x || "[0;47;30m"
"@cls";
say; say;
say "   Swap Monitor V 0.31 * (c) 1996-1997 Alessandro Cantatore - Team OS/2 Italy";
say; say"1b"x || "[47;37;1m";
say copies("", 20);
say "    " || "1b"x || "[40;32;1m" || date("L");
parse value SysCurPos() with a b;
say;
say "1b"x || "[47;34;2m" || "    Max Size        Current Size";
say;
parse value SysCurPos() with x y;
say; say;
say " " || "1b"x || "[0;47;30m" || "";
say;
say " " || "1b"x || "[40;32;1m" || "";
say "1b"x || "[47;37;1m" || " " || "1b"x || "[40;32;1m" || "Mbyte:  10        20        30        40        50        60        70        "
say "1b"x || "[0;47;30m " || "" ;
say;
say "1b"x || "[47;30;1m" || copies("", 20);
call time("E");
do forever
   call SysCurPos a-1, 65;
   say  "1b"x || "[40;32;1m" || time();
   call SysFileTree swappath, "file", "F";
   parse var file.1 . . size . ;
   kbsize = format(size / 1024, 6);
   ffsize = left(kbsize, 3) || "." || right(kbsize, 3);
   bar = copies("", size % (1048576));
   select  
      when substr(option, 2, 1) = "A" then do  /* "append" mode */
         if ffsize > maxsize then do
            maxsize = ffsize;
            call lineout logfile, date() "-" time(),
                         " - swapper.dat - dimensione massima:" maxsize "Kbyte";
            call lineout logfile;
            end /* do */
         end /* do */
      when substr(option, 2, 1) = "S" then do /* history mode */
         if ffsize > maxsize then
            maxsize = ffsize;
         logtime = substr(option, 3)
         if \datatype(logtime, "N") then
            logtime = 10;
         parse value time("E") with sec "." .;
         if (sec / 60)  > logtime | sec < 1 then do
            call time("R");
            call lineout logfile, date() "-" time() maxsize ||,
                         "Kbyte" copies("", size % (1048576));
            call lineout logfile;
            end /* do */
         end /* do */
      otherwise do
         if ffsize > maxsize then do
            maxsize = ffsize;
            call lineout logfile, , 1;
            call lineout logfile, date() "-" time(),
                         " - swapper.dat - dimensione massima:" maxsize "Kbyte";
            call lineout logfile;
            end /* do */
         end /* do */
      end  /* select */
   call SysCurPos x, y;
   say "1b"x || "[47;31m" || " " || maxsize  || " Mbyte     " || ffsize || " Mbyte";
   say;
   say 
   say " " || "1b"x || "[40;32;1m" || bar || copies(" ", 78 - length(bar));
   say;
   call SysSleep interval;
end /* do */
exit

showusage:
   say "  Swap Monitor V 0.31 * (c) 1996-1997 Alessandro Cantatore - Team OS/2 Italy";
   say;
   say "  SWAPMON.CMD monitorizza la dimensione corrente e quella massima";
   say "  raggiunte dal file di swap, mostrandone i dati sullo schermo e";
   say "  scrivendo la dimensione massima nel file swapmon.log.";
   say "  Uso:";
   say "  SWAPMON [interval] [/A|/S|/O]";
   say "  oppure:"
   say "  SWAPMON [/?|/h|/H]";
   say "  interval      rappresenta l'intervallo tra due monitorizzazioni";
   say "                successive, in secondi. Il valore di default  5;";
   say "  Le seguenti opzioni possono essere introdotte sia da ""-"" che da ""/"".";
   say "  Opzioni di scrittura del file di log:";
   say "  /A            (append) aggiunge una nuova riga con le dimensioni";
   say "                del file di swap ogni volta che vien superato il";
   say "                il valore massimo precedente";
   say "  /Sn           (history) scrive le dimensioni del file di swap nel";
   say "                swapmon.log ogni n minuti (default = 10)";
   say "  /O            (overwrite) la scrittura della dimensione del file di";
   say "                swap viene effettuata sovrascrivendo la precedente";
   say "                il default  overwrite!";
   say "  Help:"
   say "  /?, /H o /h   mostra questo messaggio.";
exit;